<?php
$page = 'refund-policy';
$pageDesc = 'Refund Policy of  — learn about eligibility, process, and terms for refunds.';
include 'includes/header.php';
?>

<section class="sec-padding">
  <div class="container">
    <div class="row">
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 center mtpx-50">
        <h2 class="main-heading">Refund Policy</h2>
        <p class="main-para">
          At <?php echo $name?>, customer satisfaction is our priority. 
          If you are not entirely satisfied with your purchase, we’re here to help. 
          Please read our refund policy to understand the terms and conditions under which refunds are processed.
        </p>
      </div>
    </div>

    <div class="row">
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">

        <h3>Eligibility for Refunds</h3>
        <p>We offer refunds under the following conditions:</p>
        <ul class="list-simple">
          <li><i class="fas fa-circle"></i>If you have purchased our service, refunds may be granted within 14 days of purchase, provided that the service has not been fully delivered or consumed.</li>
        </ul>

        <h3>How to Request a Refund</h3>
        <p>To initiate a refund, please follow these steps:</p>
        <ul class="list-simple">
          <li><i class="fas fa-circle"></i>Contact Us: Send an email to <a href="mailto:<?php echo $email?>"><?php echo $email?></a> with your order number and reason for requesting a refund.</li>
        </ul>

        <h3>Refund Processing</h3>
        <p>Once we receive your request and/or returned item, we will inspect it and notify you of the status of your refund:</p>
        <ul class="list-simple">
          <li><i class="fas fa-circle"></i><strong>Approved Refunds:</strong> If your refund is approved, a credit will automatically be applied to your original method of payment within 7–10 business days.</li>
          <li><i class="fas fa-circle"></i><strong>Late or Missing Refunds:</strong> If you haven’t received your refund after 10 business days, please check with your bank or credit card provider. If issues persist, contact us again at <a href="mailto:<?php echo $email?>"><?php echo $email?></a>.</li>
        </ul>

        <h3>Changes to the Refund Policy</h3>
        <p>We reserve the right to modify this Refund Policy at any time. Any changes will be posted on this page, and significant changes will be communicated via email or website notification.</p>

      </div>
    </div>
  </div>
</section>

<style>
h2, h3 {
  font-weight: 600;
  font-size: 34px;
}
.list-simple {
  list-style: none;
  padding-left: 0;
}
.list-simple li {
  margin-bottom: 10px;
}
.list-simple i {
  color: #000;
  font-size: 8px;
  margin-right: 6px;
}
</style>

<?php include 'includes/footer-form.php'; ?>
<?php include 'includes/footer.php'; ?>
