<?php
$page = 'refund-optout';
$pageDesc = 'Refund and opt-out policies of  — learn about refunds, communication preferences, and data sharing controls.';
include 'includes/header.php';
?>

<section class="sec-padding">
  <div class="container">

    <div class="row">
      <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">

        <!-- Opt Out Option Section -->
        <h2 class="main-heading">Opt Out Option</h2>
        <p class="main-para">
          We respect your preferences and are committed to giving you control over the communications and services you receive from us.
          If you wish to stop receiving certain communications or to opt out of specific services, please review the options below.
        </p>

        <h3>Email Communications</h3>
        <p>If you no longer wish to receive marketing or promotional emails from us:</p>
        <ul class="list-simple">
          <li><i class="fas fa-circle"></i>Click the “Unsubscribe” link at the bottom of any email you receive from us.</li>
          <li><i class="fas fa-circle"></i>Alternatively, email us at <a href="mailto:<?php echo $email?>"><?php echo $email?></a> with the subject line <strong>Unsubscribe</strong>.</li>
        </ul>
        <p>Please note that by opting out of marketing emails, you may still receive important account-related communications, such as purchase confirmations or service updates.</p>

        <h3>Text Message (SMS) Communications</h3>
        <p>To stop receiving text messages (SMS) from us:</p>
        <ul class="list-simple">
          <li><i class="fas fa-circle"></i>Reply “STOP” to any text message you receive.</li>
          <li><i class="fas fa-circle"></i>You can also contact us at <a href="mailto:<?php echo $email?>"><?php echo $email?></a> with your phone number and request to be removed from our SMS list.</li>
        </ul>

        <h3>Direct Mail</h3>
        <p>If you no longer wish to receive printed marketing materials or direct mail from us:</p>
        <ul class="list-simple">
          <li><i class="fas fa-circle"></i>Send your request along with your mailing address to <a href="mailto:<?php echo $email?>"><?php echo $email?></a>.</li>
        </ul>

        <h3>Personalized Services & Targeted Advertising</h3>
        <p>We may use your data to provide personalized services or targeted ads. If you would like to opt out of this:</p>
        <ul class="list-simple">
          <li><i class="fas fa-circle"></i>You can adjust your preferences through the account settings on our website.</li>
          <li><i class="fas fa-circle"></i>Alternatively, contact us at <a href="mailto:<?php echo $email?>"><?php echo $email?></a> with your request.</li>
        </ul>

        <h3>Third-Party Sharing</h3>
        <p>We may occasionally share your information with trusted partners for marketing or other purposes. To opt out of third-party data sharing:</p>
        <ul class="list-simple">
          <li><i class="fas fa-circle"></i>Update your preferences through your account settings.</li>
          <li><i class="fas fa-circle"></i>You can also email <a href="mailto:<?php echo $email?>"><?php echo $email?></a> with a request to opt out of data sharing.</li>
        </ul>

        <h3>Opting Out of Services</h3>
        <p>If you wish to cancel or opt out of any of our services:</p>
        <ul class="list-simple">
          <li><i class="fas fa-circle"></i>Contact us at <a href="mailto:<?php echo $email?>"><?php echo $email?></a> and we will assist you in canceling your service and ensuring no further charges or communications are made.</li>
        </ul>

        <h3>Changes to Your Preferences</h3>
        <p>You can update or modify your opt-out preferences at any time by contacting us or through your account settings on our website.</p>

      </div>
    </div>
  </div>
</section>

<style>
h2, h3 {
  font-weight: 600;
  font-size: 34px;
}
.list-simple {
  list-style: none;
  padding-left: 0;
}
.list-simple li {
  margin-bottom: 10px;
}
.list-simple i {
  color: #000;
  font-size: 8px;
  margin-right: 6px;
}
</style>

<?php include 'includes/footer-form.php'; ?>
<?php include 'includes/footer.php'; ?>
